﻿namespace Hims.Shared.UserModels.ExcelUploads
{
    using System.Collections.Generic;

    /// <summary>
    /// The pharmacy ware house upload model.
    /// </summary>
    public class PharmacyWareHouseUploadModel
    {
        /// <summary>
        /// Gets or sets the ware houses.
        /// </summary>
        /// <value>
        /// The ware houses.
        /// </value>
        public List<WareHouseUploadModel> WareHouses { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the excel upload history id. 
        /// </summary>
        public int ExcelUploadHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the sheet name.
        /// </summary>
        public string SheetName { get; set; }

        /// <summary>
        /// Gets or sets the value indicating is create log.
        /// </summary>
        public bool IsCreateLog { get; set; }
    }

    /// <summary>
    /// The ware house upload model.
    /// </summary>
    public class WareHouseUploadModel
    {
        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the is central.
        /// </summary>
        /// <value>
        /// The is central.
        /// </value>
        public string IsCentral { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public string Location { get; set; }
    }
}
