﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.ServiceOrder
{
    using System;
    using Dapper.Attributes;
    
    /// <summary>
    /// The Service Order insert model
    /// </summary>
    public class AutomaticInsertModel
    {
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public double BedCost { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is bed; otherwise, <c>false</c>.
        /// </value>
        public bool IsBed { get; set; }

        /// <summary>
        /// Gets or sets the doctor cost.
        /// </summary>
        /// <value>
        /// The doctor cost.
        /// </value>
        public double DoctorCost { get; set; }

        /// <summary>
        /// Gets or sets the doctor cost once.
        /// </summary>
        /// <value>
        /// The doctor cost once.
        /// </value>
        public double DoctorCostOnce { get; set; }

        /// <summary>
        /// Gets or sets the no of days.
        /// </summary>
        /// <value>
        /// The no of days.
        /// </value>
        public int NoOfDays { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the room charge category identifier.
        /// </summary>
        /// <value>
        /// The room charge category identifier.
        /// </value>
        public int? RoomChargeCategoryId { get; set; } 
    }
}
