﻿namespace Hims.Domain.Entities.Inventory
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The inventory issued stock detail.
    /// </summary>
    public class InventoryIssuedStockDetail
    {
        /// <summary>
        /// Gets or sets the inventory issued stock detail identifier.
        /// </summary>
        /// <value>
        /// The inventory issued stock detail identifier.
        /// </value>
        [Key,Identity]
        public long InventoryIssuedStockDetailId { get; set; }

        /// <summary>
        /// Gets or sets the inventory issued stock header identifier.
        /// </summary>
        /// <value>
        /// The inventory issued stock header identifier.
        /// </value>
        public long InventoryIssuedStockHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the inventory product identifier.
        /// </summary>
        /// <value>
        /// The inventory product identifier.
        /// </value>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the inventory stock identifier.
        /// </summary>
        /// <value>
        /// The inventory stock identifier.
        /// </value>
        public int InventoryStockId { get; set; }
    }
}
