﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities
{
    /// <summary>
    /// The account.
    /// </summary>
    public class LocationSpecializationMap
    {
        /// <summary>
        /// Gets or sets the location specialization map identifier.
        /// </summary>
        /// <value>
        /// The location  master specialization map identifier.
        /// </value>
        [Key, Identity]
        public int LocationSpecializationMapId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int SpecializationId { get; set; }
    }
}