﻿using System.Collections.Generic;

namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Ward = Shared.UserModels.BedManagement.Ward;
    using Room = Shared.UserModels.BedManagement.Room;
    using Status = Shared.UserModels.BedManagement.Status;
    using Bed = Shared.UserModels.BedManagement.Bed;
    using Hims.Shared.UserModels;
    using System;

    /// <summary>
    /// The Bed Management Service
    /// </summary>
    public interface IBedManagementService
    {
        /// <summary>
        /// Fetches the wards asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Ward.ViewModel>> FetchWardsAsync(int locationId);

        /// <summary>
        /// Fetches the rooms asynchronous.
        /// </summary>
        /// <param name="wardId">The ward identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Room.ViewModel>> FetchRoomsAsync(int wardId);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <param name="roomId">The room identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<Bed.ViewModel>> FetchBedsAsync(int roomId);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<string> FetchBedsAvailabilityAsync(BedManagementFilterModel model);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<BedPatientDetailsModel> FindPatientDetailsByBedIdAsync(int bedId);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<int> FetchAvailableBedsCountAsync(int locaionId);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<int> FetchBookedBedsCountAsync(int locationId);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<int> FetchUnderCleaningBedsCountAsync(int locationId);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<int> FetchTotalBedsCountAsync(int locationId);
        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Status.ViewModel>> FetchBedStatusItemsAsync(int locationId);
    }
}
