﻿namespace Hims.Domain.Services
{
   using System.Collections.Generic;
    using System.Threading.Tasks;
   using Shared.EntityModels;
 //   using Shared.UserModels.Filters;

    /// <summary>
    /// The DynamicReportService interface.
    /// </summary>
    public interface IDynamicReportService
    {
        ///// <summary>
        ///// The Query Execute async.
        ///// </summary>
        ///// <param name="model">
        ///// The model.
        ///// </param>
        ///// <returns>
        ///// The <see cref="Task"/>.
        ///// </returns>
        //Task<IEnumerable<object>> ExecuteQueryAsync(DynamicReportModel model);

        /// <summary>
        /// Insert/Save the  Recoed Query.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(DynamicReportModel model);


        /// <summary>
        /// The Query Execute async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<DynamicReportModel>> FetchAsync(DynamicReportFilterModel model);

        /// <summary>
        /// Deletes the package charge asynchronous.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>

        Task<int> DeactivateAsync(int? id, int? modifiedBy);

        /// <summary>
        /// update the Query
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>

        Task<int> UpdateAsync(DynamicReportModel model);

        /// <summary>
        ///  to Fetch Verified Reports Query Entry
        /// </summary>

        Task<IEnumerable<DynamicReportModel>> GetReportMenuAsync();

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<FetchModuleTemplatesModel>> FetchModuleTemplatesAsync(); 

        /// <summary>
        /// The Query Execute async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DynamicReportModel> FetchReportAsync(int reportId);

        Task<int> InsertImages(DynamicReportImagesModel model);

        Task<int> UpdateImages(string path, int id);

        Task<IEnumerable<DynamicReportImagesModel>> FetchImagePath();
    }
}
