﻿namespace Hims.Domain.Services
{
    using Hims.Domain.Entities.Vendors;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.Vendors;

    /// <summary>
    /// The quotation service interface.
    /// </summary>
    public interface IQuotationService
    {
        /// <summary>
        /// Called when [incoming quotation asynchronous].
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<long> OnIncomingQuotationAsync(IncomingQuotationHeaderModel model);

        /// <summary>
        /// Fetches the incoming quotation asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<IncomingQuotationHeaderModel>> FetchIncomingQuotationAsync(IncomingQuotationHeaderModel model);

        /// <summary>
        /// Deletes the quotation asynchronous.
        /// </summary>
        /// <param name="incomingQuotationHeaderId">The incoming quotation header identifier.</param>
        /// <returns></returns>
        Task<int> DeleteQuotationAsync(long incomingQuotationHeaderId);

        /// <summary>
        /// Called when [accept quotation].
        /// </summary>
        /// <param name="incomingQuotationHeaderId">The incoming quotation header identifier.</param>
        /// <param name="createdBy">The created by.</param>
        /// <returns></returns>
        Task<int> OnAcceptQuotation(long incomingQuotationHeaderId, int createdBy);
    }
}