﻿namespace Hims.Infrastructure.Helpers
{
    using System;
    using System.Security.Cryptography;
    using System.Text;
    using Domain.Helpers;

    /// <inheritdoc />
    public class ShaHelper : IShaHelper
    {
        /// <inheritdoc />
        public string GenerateHash(string password, string saltKey)
        {
            using (var sha = SHA256.Create())
            {
                var computedHash = sha.ComputeHash(Encoding.Unicode.GetBytes(password + saltKey));
                return Convert.ToBase64String(computedHash);
            }
        }
    }
}