﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The message.
    /// </summary>
    public class Message
    {
        /// <summary>
        /// Gets or sets the message id.
        /// </summary>
        [Key, Identity]
        public long MessageId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        [IgnoreUpdate]
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        [IgnoreUpdate]
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the messages.
        /// </summary>
        public string Messages { get; set; }

        /// <summary>
        /// Gets or sets the doctor message count.
        /// </summary>
        public int? DoctorMessageCount { get; set; }

        /// <summary>
        /// Gets or sets the patient message count.
        /// </summary>
        public int? PatientMessageCount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        [IgnoreUpdate]
        public bool Active { get; set; }
    }
}