﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.Diagnostics.CodeAnalysis;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The supplier.
    /// </summary>
    public class Supplier
    {
        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        [Key, Identity]
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the due days.
        /// </summary>
        /// <value>
        /// The due days.
        /// </value>
        public int? DueDays { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }
        
        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the pin code.
        /// </summary>
        public string PinCode { get; set; }

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string City { get; set; }

        /// <summary>
        /// Gets or sets the supplier of.
        /// </summary>
        public string SupplierOf { get; set; }

        /// <summary>
        /// Gets or sets the address.
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets bank name.
        /// </summary>
        public string BankName { get; set; }

        /// <summary>
        /// Gets or sets the ifsc code.
        /// </summary>
        public string IfscCode { get; set; }

        /// <summary>
        /// Gets or sets the account numbet.
        /// </summary>
        public string AccountNumber { get; set; }

        /// <summary>
        /// Gets or sets the account holder name.
        /// </summary>
        public string AccountHolderName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the user identifier.
        /// </summary>
        /// <value>
        /// The user identifier.
        /// </value>
        public int? UserId { get; set; }

        /// <summary>
        /// Gets or sets the name of the contact person.
        /// </summary>
        /// <value>
        /// The name of the contact person.
        /// </value>
        public string ContactPersonName { get; set; }

        /// <summary>
        /// Gets or sets the drug license.
        /// </summary>
        /// <value>
        /// The drug license.
        /// </value>
        public string DrugLicense { get; set; }

        /// <summary>
        /// Gets or sets the GST no.
        /// </summary>
        /// <value>
        /// The GST no.
        /// </value>
        public string GSTNo { get; set; }

        /// <summary>
        /// Gets or sets the pan.
        /// </summary>
        /// <value>
        /// The pan.
        /// </value>
        public string Pan { get; set; }

        /// <summary>
        /// Gets or sets the deliver days.
        /// </summary>
        /// <value>
        /// The deliver days.
        /// </value>
        public int? DeliverDays { get; set; }
    }
}
