﻿export class CalculateDiscounttHelper {

    static convertRupeesToPercentage(originalAmount: number, discountAmount: number) {
        const discountPercentage = (discountAmount / originalAmount) * 100;
        const discountDecimal = discountAmount / originalAmount;
        const discountedAmount = originalAmount - discountAmount;
        const percentageDecimal = discountPercentage / 100;

        return { discountPercentage, discountedAmount, discountDecimal, percentageDecimal };
    }

    static convertPercentageToRupees(originalAmount: number, discountPercentage: number) {
        const discountDecimal = discountPercentage / 100;
        const discountAmount = originalAmount * discountDecimal;
        const discountedAmount = originalAmount - discountAmount;

        return { discountDecimal, discountAmount, discountedAmount };
    }

    static applyPercentageDiscount(amount: number, discountPercentage: number): number {
        const discountAmount = (amount * discountPercentage) / 100;
        //const discountedAmount = amount - discountAmount;
        return discountAmount;
    }

    static applyRupeesDiscount(amount: number, discountInRupees: number): number {
        const discountedAmount = amount - discountInRupees;
        return discountedAmount;
    }

}