﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The inventory purchase detail model.
    /// </summary>
    public class InventoryPurchaseDetailModel
    {
        /// <summary>
        /// Gets or sets the inventory purchase detail id.
        /// </summary>
        public int InventoryPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the inventory purchase header id.
        /// </summary>
        public int InventoryPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the serial no.
        /// </summary>
        public int SerialNo { get; set; }

        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the inventory stock id.
        /// </summary>
        public int InventoryStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public double Quantity { get;set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public double Free { get;set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get;set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get;set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        public double TaxPerItem { get;set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get;set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double DiscountPerItem { get;set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double Discount { get;set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get;set; }
    }
}
