﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The hoc patient model.
    /// </summary>
    public class AppointmentTypesModel
    {
        /// <summary>
        /// Gets or sets the appointment type id.
        /// </summary>
        /// <value>
        /// The HWC patient identifier.
        /// </value>      
        public int AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the appointment.
        /// </summary>
        /// <value>
        /// The name of the HWC.
        /// </value>
        public string Name { get; set; }
        
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public string CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }


        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }
    }
}
