﻿using Hims.Shared.Library.Enums;
using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.DietEncounter
{
    public class InsertModel
    {

        public int DietEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        public DateTime DietEncounterDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the isadmission.
        /// </summary>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string? JsonString { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public DietEncounterType Type { get; set; }

        /// <summary>
        /// DietPlanPrescribed
        /// </summary>
        public string? DietPlanPrescribed { get; set; }

        /// <summary>
        /// OpNutritionScreeningForm
        /// </summary>
        public string? OpNutritionScreeningForm { get; set; }

        /// <summary>
        /// OpNutritionalAssessmentForm
        /// </summary>
        public string OpNutritionalAssessmentForm { get; set; }

        /// <summary>
        /// IpNutritionalScreeningForm
        /// </summary>
        public string? IpNutritionalScreeningForm { get; set; }

        /// <summary>
        /// PediatricCDCScreeningForm
        /// </summary>
        public string? PediatricCDCScreeningForm { get; set; }

        /// <summary>
        /// DietGuideLines
        /// </summary>
        public string? DietGuideLines { get; set; }

        /// <summary>
        /// SyndromesFormP
        /// </summary>
        public string? SyndromesFormP { get; set; }

        /// <summary>
        /// OrdersPrescription
        /// </summary>
        public string? OrdersPrescription { get; set; }

        /// <summary>
        /// ReferralForm
        /// </summary>
        public string? ReferralForm { get; set; }

        public int? PatientId { get; set; }
    }
}
