﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class Ambulance
    {
        /// <summary>
        /// get or set AmbulanceId
        /// </summary>
        [Key,Identity]
        public int AmbulanceId { get; set; }

        /// <summary>
        /// get or set AmbulanceNo
        /// </summary>
        public string AmbulanceNo { get; set; }

        /// <summary>
        /// get or set AssignedNo
        /// </summary>
        public string AssignedNo { get; set; }

        /// <summary>
        /// get or set a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// get or set CreatedDate
        /// </summary>
        /// 
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// get or set
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// get or set ModifiedBy
        /// </summary>
     
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// get or set ModifiedDate
        /// </summary>
       
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// get or set
        /// </summary>
        public int LocationId { get; set; }

    }
}
