﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Payment Initiation Log.
    /// </summary>
    public class AppointmentCheckPoints
    {
        /// <summary>
        /// Gets or sets the Payment Initiation Log id.
        /// </summary>
        [Key, Identity]
        public int AppointmentCheckPointsId { get; set; }

        /// <summary>
        /// Gets or sets the Payment Initiation Log id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the json data.
        /// </summary>
        public string Action { get; set; }

        /// <summary>
        /// Gets or sets the Payment Initiation Log id.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the Payment Initiation Log id.
        /// </summary>
        public int? ExternalUserId { get; set; }

        public bool? IgnoreForQueue { get; set; }
    }
}
