﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment exception log.
    /// </summary>
    public class AppointmentExceptionLog
    {
        /// <summary>
        /// Gets or sets the appointment exception log id.
        /// </summary>
        [Key, Identity]
        public int AppointmentExceptionLogId { get; set; }

        /// <summary>
        /// Gets or sets the appointment log id.
        /// </summary>
        public int? AppointmentLogId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether payment status.
        /// </summary>
        [IgnoreUpdate]
        public bool PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the exception date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime ExceptionDate { get; set; }

        /// <summary>
        /// Gets or sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the stack trace.
        /// </summary>
        public string? StackTrace { get; set; }

        /// <summary>
        /// Gets or sets the payment transaction id.
        /// </summary>
        public string? PaymentTransactionId { get; set; }
    }
}
