﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary> The general advice.</summary>
    public class GeneralAdvice
    {
        /// <summary>Gets or sets the general advice id.</summary>
        /// <summary>
        /// Gets or sets the general advice id.
        /// </summary>
        [Key, Identity]
        public int GeneralAdviceId { get; set; }

        /// <summary>Gets or sets the full name.</summary>
        public string? FullName { get; set; } 

        /// <summary>Gets or sets the description.</summary>
        public string? Description { get; set; }

        /// <summary>Gets or sets the created by.</summary>
        public int CreatedBy { get; set; }

        /// <summary>Gets or sets the created date.</summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>Gets or sets the modified by.</summary>
        public int? ModifiedBy { get; set; }

        /// <summary>Gets or sets the modified date.</summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
