﻿
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Shared.Dapper.Attributes;

    
    public class Relations
    {
        /// <summary>
        /// Gets or sets the RelationsId of Relations table.
        /// </summary>
        
        [Key,Identity]
        public int RelationsId { get; set; }

        /// <summary>
        /// Gets or sets the RelationName.
        /// </summary>
        public string RelationName { get; set; }


        /// <summary>
        /// Gets or sets the Ro.
        /// </summary>
        public string RO { get; set; }
        /// <summary>
        /// Gets or sets the Status.
        /// </summary>
        public bool ? Active { get; set; }
        /// <summary>
        /// Gets or sets id of creator.
        /// </summary>

        [IgnoreUpdate]
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets id of modifier.
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets date of creation.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets date of modification.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

    }
}
