﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;

    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The retail pharmacy.
    /// </summary>
    public class RetailPharmacy
    {
        /// <summary>
        /// Gets or sets the retail pharmacy id.
        /// </summary>
        [Key, Identity]
        public int RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the retail name.
        /// </summary>
        public string RetailName { get; set; }


        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets Active.
        /// </summary>
        public bool Active { get; set; }
    }
}
