﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.TemplateDesign.Component;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary>
    /// The component Service interface.
    /// </summary>
    public interface IComponentService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchModel>> FetchAllAsync(FetchModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// Deletes the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteAsync(DeleteModel model);
    }
}
