﻿namespace Hims.Domain.Services
{
    using Hims.Domain.Entities;
    using Hims.Domain.Entities.Labs;
    using Shared.EntityModels;
    using Shared.UserModels.Labs;
    using Shared.UserModels.Labs.Report;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    /// <summary>
    /// The Labs Service interface.
    /// </summary>
    public interface ILabsService
    {
        /// <summary>
        /// The create unit async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateUnitAsync(LookupValueModel model);

        /// <summary>
        /// Fetches all parameter method.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<LabParameterMethod>> FetchAllParameterMethod();

        /// <summary>
        /// Modifies the lab parameteres asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyLabParameteresAsync(LabParameterModel model);

        /// <summary>
        /// Fetches the lab parameter header asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabParameterModel>> FetchLabParameterHeaderAsync(LabParameterModel model);

        /// <summary>
        /// Fetches the lab parameter detail asynchronous.
        /// </summary>
        /// <param name="labParameterHeaderId">The lab parameter header identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<LabParameterDetailModel>> FetchLabParameterDetailAsync(int labParameterHeaderId);

        /// <summary>
        /// Modifies the lab components asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyLabComponentsAsync(LabComponentModel model);

        /// <summary>
        /// Fetches the lab component header asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabComponentModel>> FetchLabComponentHeaderAsync(LabComponentModel model);

        /// <summary>
        /// Fetches the lab component detail asynchronous.
        /// </summary>
        /// <param name="labComponentHeaderId">The lab component header identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<LabComponentDetailModel>> FetchLabComponentDetailAsync(int labComponentHeaderId);

        /// <summary>
        /// Modifies the template asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyTemplateAsync(LabTemplateModel model);

        /// <summary>
        /// Fetches the lab template header asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabTemplateModel>> FetchLabTemplateHeaderAsync(LabTemplateModel model);

        /// <summary>
        /// Fetches the lab template detail asynchronous.
        /// </summary>
        /// <param name="labTemplateHeaderId">The lab template header identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<LabTemplateDetailModel>> FetchLabTemplateDetailAsync(int labTemplateHeaderId);

        /// <summary>
        /// Modifies the lab master.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyLabMaster(LabMainDetailModel model);

        /// <summary>
        /// Fetches all sample type asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<LabSampleTypeModel>> FetchAllSampleTypeAsync();

        /// <summary>
        /// Fetches all lab main detail asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabMainDetailModel>> FetchAllLabMainDetailAsync(LabMainDetailModel model);
        
        /// <summary>
        /// Fetches the lab tagged templates.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabMainDetailTemplateModel>> FetchLabTaggedTemplates(LabMainDetailTemplateModel model);

        /// <summary>
        /// Modifuies the status of parameter asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyParameterStatusAsync(LabParameterModel model);

        /// <summary>
        /// Modifuies the status of component asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyComponentStatusAsync(LabComponentModel model);

        /// <summary>
        /// Modifuies the status of template asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyTemplateStatusAsync(LabTemplateModel model);

        /// <summary>
        /// Modifuies the status of labdetail asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyLabMainDetailStatusAsync(LabMainDetailModel model);

        /// <summary>
        /// Fetches the lab Bookings.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabBookingModel>> FetchLabBookings(LabBookingModel model);

        /// <summary>
        /// Cancel the Single lab Booking.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> LabBookingsCancelling(LabBookingModel model);

        /// <summary>
        /// Fetches the added lab bill asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabBookingModel>> FetchCancelledLabBillAsync(LabBookingModel model);

        /// <summary>
        /// Fetches the selected lab data asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabBookingModel>> FetchSelectedLabDataAsync(LabBookingModel model);

        /// <summary>
        /// Fetches all parameter method.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<LabBookingStatus>> FetchAllLabStatus();

        /// <summary>
        /// Updates the status color asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateStatusColorAsync(LabBookingAllStatusModel model);

        /// <summary>
        /// Fetches all lab charge categories.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ChargeCategory>> FetchAllLabChargeCategories();

        /// <summary>
        /// Fetches all available import lab asynchronous.
        /// </summary>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<NewLabImportModel>> FetchAllAvailableImportLabAsync(int locationId);
        /// <summary>
        /// Imports the lab.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ImportLabAsync(NewLabImportModel model);

        /// <summary>
        /// Fetches the transfered labs asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabTransferModel>> FetchResultAddedLabsAsync(LabTransferModel model);

        /// <summary>
        /// Assigns the lab report asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AssignLabReportAsync(LabReportVerificationModel model);

        /// <summary>
        /// Doctors the verification lab report asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DoctorVerificationLabReportAsync(LabDoctorVerificationModel model);

        /// <summary>
        /// Fetches the doctor lab report signature asynchronous.
        /// </summary>
        /// <param name="newLabBookingDetailId">The new lab booking detail identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<LabReportProviderSignatureModel>> FetchDoctorLabReportSignatureAsync(int newLabBookingDetailId);

        /// <summary>
        /// Fetches the doctors assigned lab report asynchronous.
        /// </summary>
        /// <param name="newLabBookingDetailId">The new lab booking detail identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<ProviderIds>> FetchDoctorsAssignedForLabReportAsync(int newLabBookingDetailId);

        /// <summary>
        /// Fetches the transfered labs.
        /// </summary>
        /// <param name="transferId">The transfer identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<LabTransferModel>> FetchTransferedLabs(int transferId);

        /// <summary>
        /// Fetches all machines.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Machine>> FetchAllMachines();

        /// <summary>
        /// Deletings the doctorto reports.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeletingDoctortoReports(LabReportVerificationModel model);

        /// <summary>
        /// Fetches the patient labs asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabReportPatientModel>> FetchPatientLabsAsync(LabReportPatientModel model);

        /// <summary>
        /// Fetches the labs for sample collection asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabSampleHandlerModel>> FetchSamplecollectiontrackreports(LabSampleHandlerModel model);

        /// <summary>
        /// Fetches the labs for sample collection asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabBookingModel>> FetchLabReports(LabBookingModel model);

        /// <summary>
        /// Fetches all lab parameter observed values asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabParameterResultsModel>> FetchAllLabParameterObservedValuesAsync(LabTransferModel model);

        /// <summary>
        /// Fetches the selected lab data for web reports.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabBookingModel>> FetchSelectedLabDataForWebReports(LabBookingModel model);

        /// <summary>
        /// Changes the sample process status asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ChangeSampleProcessStatusAsync(LabTransferModel model);

        /// <summary>
        /// Fetches the transfered labs asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabTransferModel>> FetchTransferedLabsAsync(LabTransferModel model);

        /// <summary>
        /// Creates new doctorassigning.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> NewDoctorAssigning(NewDoctorAssigningModel model);
        /// <summary>
        /// Fetches the labs for sample collection asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabBookingModel>> FetchLabStatusReports(LabBookingModel model);

        /// <summary>
        /// Fetches the patient past lab reports asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PatientPastLabReportsModel>> FetchPatientPastLabReportsAsync(PatientPastLabReportsModel model);

        Task<int> ChangeHoldStatusOfTest(LabHoldStatusModel model);

        /// <summary>
        /// Fetches the labs for sample collection asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabTATReportModel>> FetchLabTatReports(LabBookingModel model);

        /// <summary>
        /// Fetches the appointment mobile labs asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ApointmentLabsMobileModel>> FetchAppointmentMobileLabsAsync(ApointmentLabsMobileModel model);

        /// <summary>
        /// Fetches the external lab agency asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ExternalLabAgencyModel>> FetchExternalLabAgencyAsync(ExternalLabAgencyModel model);

        /// <summary>
        /// Fetches the external lab agency details asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<ExternalLabAgencyModel> FetchExternalLabAgencyDetailsAsync(ExternalLabAgencyModel model);

        /// <summary>
        /// Activates the or deactivate machine.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateExternalLabAgency(ExternalLabAgencyModel model);

        /// <summary>
        /// Activates the or deactivate external lab agency detail.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateExternalLabAgencyDetail(ExternalLabAgencyDetailModel model);

        /// <summary>
        /// Modifies the external lab agency.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyExternalLabAgency(ExternalLabAgencyModel model);

        /// <summary>
        /// Modifies the external lab agency detail.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyExternalLabAgencyDetail(List<ExternalLabAgencyDetailModel> model);

        /// <summary>
        /// Fetches the lab with charge category charge asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabChargeCategoryChargeModel>> FetchLabWithChargeCategoryChargeAsync(LabChargeCategoryChargeModel model);

        /// <summary>
        /// Fetches the sample collected asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<NewLabSampleHandlerModel>> FetchSampleCollectedAsync(NewLabSampleHandlerModel model);

        /// <summary>
        /// Uns the collect samples asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <param name="locationId">The location identifier.</param>
        /// <returns></returns>
        Task<int> UnCollectSamplesAsync(List<LabSampleHandlerModel> model,int locationId);

        /// <summary>
        /// Gets all sample uncollect reasons.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<string>> GetAllSampleUncollectReasons();

        /// <summary>
        /// Gets all sample reject reasons.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<string>> GetAllSampleRejectReasons();

        /// <summary>
        /// Checks the lab is tagged or not asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<bool> CheckLabIsTaggedOrNotAsync(ExternalLabAgencyDetailModel model);

        /// <summary>
        /// Fetches the test parameters for lis asynchronous.
        /// </summary>
        /// <param name="NewLabBookingDetailId">The new lab booking detail identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<LISParamsFetchUserModel>> FetchTestParamsForLISAsync(int NewLabBookingDetailId);

        /// <summary>
        /// Inserts the test parameters of lis asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertTestParamsOfLISAsync(List<LISParamsFetchUserModel> model);

    }
}
