﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels;
    using Shared.UserModels.OperationTheater;

    /// <summary>
    /// The operation Service interface.
    /// </summary>
    public interface IOperationService
    {
        /// <summary>
        /// Raises the ot indent.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> RaiseOTIndent(OTRaiseIndentModel model);

        /// <summary>
        /// Fetches the raised indents.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTIndentModel>> FetchRaisedIndents(OTIndentModel model);

        /// <summary>
        /// Fetches the indent details.
        /// </summary>
        /// <param name="headerId">The header identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<ProductModel>> FetchIndentDetails(int headerId);

        /// <summary>
        /// Gets the pending indent count.
        /// </summary>
        /// <param name="type">The type.</param>
        /// <returns></returns>
        Task<int> GetPendingIndentCount(string type);

        /// <summary>
        /// Fetches the operation stocks.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyStockModel>> FetchOperationStocks(PharmacyStockModel model);

        /// <summary>
        /// Inserts the surgery asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertSurgeryAsync(SurgeryModel model);
        
        /// <summary>
        /// Inserts the surgery asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateSurgeryAsync(SurgeryModel model);
        /// <summary>
        /// Fetches all surgery asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<SurgeryModel>> FetchAllSurgeryAsync(SurgeryModel model);
        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(SurgeryModel model);
    }
}
