﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The PharmacyLogService interface.
    /// </summary>
    public interface IPharmacyLogService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<PharmacyLogModel>> FetchAsync(PharmacyLogFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task LogAsync(PharmacyLogModel model);
    }
}
