﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary> The ChatService interface.</summary>
    public interface ITimelineService
    {
        /// <summary>
        /// The log async.
        /// </summary>
        /// <param name="chatModel">
        /// The chat model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> LogAsync(TimelineModel chatModel);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<TimelineViewModel>> FetchAsync(TimelineRequestModel model);

        /// <summary>
        /// The fetch view async.
        /// </summary>
        /// <param name="id">
        /// The id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<TimelineDataViewModel> FetchViewAsync(int id);
    }
}
