﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Infrastructure.Services
{
    using System;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Configurations;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;
    using Shared.Library;
    using Shared.Library.Enums;
    using Shared.UserModels;
    using Hims.Shared.Library.Helpers;
    using Hims.Shared.UserModels.PediatricEncounter;
    using neonatal = Shared.UserModels.NeonatalIPEncounter;
    using System.Collections;
    using System.Collections.Generic;
    using System.Drawing;
    using System.Reflection.PortableExecutable;

    /// <inheritdoc />
    public class NeonatalIPEncounterService : INeonatalIPEncounterService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <summary>
        /// The amazon s3 configuration.
        /// </summary>
        private readonly IAmazonS3Configuration amazonS3Configuration;

        /// <summary>
        /// The timeline service.
        /// </summary>
        private readonly ITimelineService timelineService;

        private readonly IAuditLogService auditLogService;

        /// <inheritdoc cref="IGynEncounterService"/>


        Task<NeonatalIPEncounterModel> INeonatalIPEncounterService.FindAsync(int appointmentId, bool isAdmission)
        {
            throw new NotImplementedException();
        }

        public async Task<CommonResponse> UpdateAsync(neonatal.InsertModel model)
        {

            var commonResponse = new CommonResponse { Status = 1 };
            var encounter = await this.unitOfWork.NeonatalIPEncounters.FindAsync(m => m.NeonatalIPEncounterId == model.NeonatalIPEncounterId);

            var checkIf = model.IsAdmission
                 ? await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""NeonatalIPEncounterId"") FROM ""NeonatalIPEncounter"" WHERE ""NeonatalIPEncounterId"" = {model.NeonatalIPEncounterId}")
                    : await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""PediatricEncounterId"") FROM ""PediatricEncounter"" WHERE ""NeonatalIPEncounterId"" = {model.NeonatalIPEncounterId}");
            if (checkIf > 0)
            {
                commonResponse.Response = -1;
                return commonResponse;
            }

            encounter.ModifiedBy = model.ModifiedBy;
            encounter.ModifiedDate = DateTime.UtcNow;

            switch (model.Type)
            {
                case NeonatalEncounterType.NeonatalBaby:
                    encounter.NeonatalBaby = model.JsonString;
                    break;
            }
            var updated = await this.unitOfWork.NeonatalIPEncounters.UpdateAsync(encounter);

            commonResponse.Response = updated > 0 ? encounter.NeonatalIPEncounterId : 0;
            return commonResponse;
        }
        public Task<neonatal.NeonatalIPEncounterResource> FindDashboardAsync(int appointmentId, NeonatalEncounterType type, bool isAdmission)
        {
            throw new NotImplementedException();
        }

        public async Task<CommonResponse> AddAsync(neonatal.InsertModel model)
        {

            var commonResponse = new CommonResponse { Status = 1 };
            var checkIf = model.IsAdmission
                 ? await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""NeonatalIPEncounterId"") FROM ""NeonatalIPEncounter"" WHERE ""AdmissionId"" = {model.AdmissionId}")
                    : await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""PediatricEncounterId"") FROM ""PediatricEncounter"" WHERE ""AppointmentId"" = {model.AppointmentId}");
            if (checkIf > 0)
            {
                commonResponse.Response = -1;
                return commonResponse;
            }
            var admission = new Admission();
            var appointment = new Appointment();
            if (model.IsAdmission)
            {
                admission = this.unitOfWork.Admission.Find(s => s.AdmissionId == model.AppointmentId);
            }
            else
            {
                appointment = this.unitOfWork.Appointments.Find(s => s.AppointmentId == model.AppointmentId);
            }

            var encounter = new NeonatalIPEncounter
            {
                Active = true,
                AppointmentId = model.IsAdmission ? null : (int?)model.AppointmentId,

                AdmissionId = model.IsAdmission ? (int?)model.AppointmentId : null,
                NeonatalIPEncounterDate = DateTime.Now,
                CreatedBy = model.ModifiedBy,
                CreatedDate = DateTime.Now,
                PatientId = model.IsAdmission ? admission.PatientId : appointment.PatientId


            };
            switch (model.Type)
            {
                case NeonatalEncounterType.NeonatalBaby:
                    encounter.NeonatalBaby = model.JsonString;
                    break;


            }
            return commonResponse;
        }
    }
}
