﻿namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Domain.Services;
    using Hims.Shared.EntityModels;
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    public class PatientChatBoxService : IPatientChatBoxService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IPatientChatBoxService" />
        public PatientChatBoxService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<IEnumerable<PatientChatBoxModel>> FetchAsync(PatientChatBoxModel model)
        {
            var where = "where ";
            if (model.AppointmentId != 0)
            {
                where += $@"  P.""AppointmentId"" = '{model.AppointmentId}'";
            }

            var query = $@"Select P. ""PatientChatBoxId"",  P. ""Message"",P.""CreatedDate"",A.""FullName"" as ""CreatedByName""
                 from ""PatientChatBox"" P
                       left join ""Account"" A on A.""AccountId"" = P.""CreatedBy""
                       left join ""Appointment"" Am on Am.""AppointmentId""=P.""AppointmentId""
                       {where} order by ""CreatedDate"" desc";
            return await this.unitOfWork.Current.QueryAsync<PatientChatBoxModel>(query);
        }

        public async Task<int> InsertAsync(PatientChatBoxModel model)
        {

            var chatBox = new PatientChatBox
            {
                AppointmentId = model.AppointmentId,
                Message = model.Message,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now
            };
            return await this.unitOfWork.PatientChatBoxes.InsertAsync(chatBox);
        }

        //public async Task<int> UpdateAsync(PatientChatBoxModel model)
        //{
        //    var chatBox = new PatientChatBox
        //    {
        //        AppointmentId = model.AppointmentId,
        //        Message = model.Message,
        //        CreatedBy = model.CreatedBy,
        //        CreatedDate = model.CreatedDate
        //    };
        //    return await this.unitOfWork.PatientChatBoxes.UpdateAsync(chatBox);
        //}
    }
}

