﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Threading.Tasks;

    using Dapper;

    using Domain.Configurations;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Hims.Domain.Entities.Enums;
    using Shared.EntityModels;

    /// <inheritdoc />
    public class PaymentInitiationLogService : IPaymentInitiationLogService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IPaymentInitiationLogService" />
        public PaymentInitiationLogService(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
        }

        /// <inheritdoc />
        public Task<PaymentInitiationLogModel> FindAsync(int paymentInitiationLogId)
        {
            var query = $@"SELECT * FROM ""PaymentInitiationLog""
                                WHERE ""PaymentInitiationLogId""= {paymentInitiationLogId}";
            return this.unitOfWork.Current.QueryFirstOrDefaultAsync<PaymentInitiationLogModel>(query);
        }

        /// <inheritdoc />
        public async Task<int> AddAsync(PaymentInitiationLogModel model)
        {
            var paymentInitiationLog = new PaymentInitiationLog
            {
                TableData = model.TableData,
                PaymentModuleId = model.PaymentModuleId,
                Mode=model.Mode,
                CreatedBy=model.CreatedBy,
                CreatedDate=DateTime.Now
            };

            return await this.unitOfWork.PaymentInitiationLog.InsertAsync(paymentInitiationLog);
        }

        /// <inheritdoc />
        public Task<int> DeleteAsync(int paymentInitiationLogId)
        {
            var query = $@"DELETE FROM ""PaymentInitiationLog"" WHERE ""PaymentInitiationLogId""= {paymentInitiationLogId}";
            return this.unitOfWork.Current.ExecuteAsync(query);
        }
    }
}