﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class BedModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int BedId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int RoomId { get; set; }
        public string BedType { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string RoomName { get; set; }  
        
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string WardName { get; set; }    
        
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int WardId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int BedStatusId { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or Sets the bed status name.
        /// </summary>
        public string BedStatusName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string? FloorName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int? FloorId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the Location Id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

    }
}
