﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.ComponentModel.DataAnnotations;


    /// <summary>
    /// The indent header.
    /// </summary>
    public class IndentHeaderModel
    {
        /// <summary>
        /// Gets or sets the indent header id.
        /// </summary>
        public int IndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the reason for requirement.
        /// </summary>
        public string ReasonForRequirement { get; set; }

        /// <summary>
        /// Gets or sets the indent to.
        /// </summary>
        public string IndentTo { get; set; }

        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public DateTime? FromDate { get; set; }
        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int? InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }
        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public string Type { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }
    }
}
