﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The provider document.
    /// </summary>
    public class ModifyPatientDocumentModel
    {
        /// <summary>
        /// Gets or sets the provider document id.
        /// </summary>
        public int PatientDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether IsRead.
        /// </summary>
        public bool Status { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the login account  id.
        /// </summary>
        public int LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the document URL.
        /// </summary>
        /// <value>
        /// The document URL.
        /// </value>
        public string? DocumentUrl { get; set; }
    }
}
