﻿using System;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The role.
    /// </summary>
    public class PayTypeModel
    {
        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? IsActive { get; set; }

        /// <summary>
        /// Gets or sets a pay type value.
        /// </summary>
        public string PayTypeValue { get; set; }
        /// <summary>
        /// Gets or sets salucro pay type.
        /// </summary>
        public bool? SalucroPayType { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets Total Items.
        /// </summary>
        public int? TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public short? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string? CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the Modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string? ModifiedByName { get; set; }
        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
    }
}
