﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The provider.
    /// </summary>
    public class ProviderModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the  comments.
        /// </summary>
        public int? RoleId { get; set; }


        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? Salutation { get; set; }

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the middle name.
        /// </summary>
        public string? MiddleName { get; set; }

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        public string FriendlyName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public short? Age { get; set; }

        /// <summary>
        /// Gets or sets the experience.
        /// </summary>
        public double? Experience { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the marital status.
        /// </summary>
        public char? MaritalStatus { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the NPI.
        /// </summary>
        public string? NPI { get; set; }

        /// <summary>
        /// Gets or sets the provider no.
        /// </summary>
        public string? ProviderNo { get; set; }

        /// <summary>
        /// Gets or sets the country.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the salutation id.
        /// </summary>
        public int? SalutationId { get; set; }

        /// <summary>
        /// Gets or sets the country name.
        /// </summary>
        public string? CountryName { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string? DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string? CountryCode { get; set; }

        /// <summary>
        /// Gets or sets the iso code.
        /// </summary>
        public string? ISOCode { get; set; }

        /// <summary>
        /// Gets or sets the profile image url.
        /// </summary>
        public string? ProfileImageUrl { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the base 64 profile image.
        /// </summary>
        public string? Base64ProfileImage { get; set; }

        /// <summary>
        /// Gets or sets the base 64 profile image.
        /// </summary>
        public string? Base64ProfileThumbnailImage { get; set; }

        /// <summary>
        /// Gets or sets the approval status.
        /// </summary>
        public bool? ApprovalStatus { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the rejected reason.
        /// </summary>
        public string? RejectedComments { get; set; }

        /// <summary>
        /// Gets or sets the rejected date.
        /// </summary>
        public DateTime? RejectedDate { get; set; }

        /// <summary>
        /// Gets or sets the theme.
        /// </summary>
        public string? Theme { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether enable email alerts.
        /// </summary>
        public bool EnableEmailAlerts { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether enable sms alerts.
        /// </summary>
        public bool EnableSMSAlerts { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether enable desktop notifications.
        /// </summary>
        public bool EnableDesktopNotifications { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether enable mobile notifications.
        /// </summary>
        public bool EnableMobileNotifications { get; set; }

        /// <summary>
        /// Gets or sets the services.
        /// </summary>
        public string? Services { get; set; }

        /// <summary>
        /// Gets or sets the service name.
        /// </summary>
        public string? ServiceNames { get; set; }

        /// <summary>
        /// Gets or sets the specializations.
        /// </summary>
        public string? Specializations { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string? SpecializationNames { get; set; }

        /// <summary>
        /// Gets or sets the about.
        /// </summary>
        public string? About { get; set; }

        /// <summary>
        /// Gets or sets the rating.
        /// </summary>
        public double Rating { get; set; }

        /// <summary>
        /// Gets or sets the awards honors.
        /// </summary>
        public string? AwardsHonors { get; set; }

        /// <summary>
        /// Gets or sets the educations.
        /// </summary>
        public string? Educations { get; set; }

        /// <summary>
        /// Gets or sets the memberships.
        /// </summary>
        public string? Memberships { get; set; }

        /// <summary>
        /// Gets or sets the registrations.
        /// </summary>
        public string? Registrations { get; set; }

        /// <summary>
        /// Gets or sets the experiences.
        /// </summary>
        public string? Experiences { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the is locked.
        /// </summary>
        public bool? IsLocked { get; set; }

        /// <summary>
        /// Gets or sets the languages.
        /// </summary>
        public string? Languages { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the health identifier no.
        /// </summary>
        public string? HealthIdentifierNo { get; set; }

        /// <summary>
        /// Gets or sets the prescriber no.
        /// </summary>
        public string? PrescriberNo { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public decimal? ConsultationCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public decimal? TelemedicineCharges { get; set; }

        /// <summary>
        /// Gets or sets the availability.
        /// </summary>
        public string? Availability { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string? AvailableDays { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is online.
        /// </summary>
        public bool IsOnline { get; set; }

        /// <summary>
        /// Gets or sets the address line.
        /// </summary>
        public string? AddressLine { get; set; }

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string? City { get; set; }

        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public string? State { get; set; }

        /// <summary>
        /// Gets or sets the zip code.
        /// </summary>
        public string? ZipCode { get; set; }

        /// <summary>
        /// Gets or sets the percentage.
        /// </summary>
        public double? Percentage { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string? Signature { get; set; }

        /// <summary>
        /// Gets or sets the clinic picture.
        /// </summary>
        public string? ClinicPicture { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string? Base64Signature { get; set; }

        /// <summary>
        /// Gets or sets the clinic picture.
        /// </summary>
        public string? Base64ClinicPicture { get; set; }

        /// <summary>
        /// Gets or sets the  comments.
        /// </summary>
        public string? AccountFullName { get; set; }

        /// <summary>
        /// Gets or sets the  comments.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the practice location id.
        /// </summary>
        public int PracticeLocationId { get; set; }
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int? SpecializationId { get; set; }
        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string? Value { get; set; }

        /// <summary>
        /// Gets or sets the optional text.
        /// </summary>
        public string? OptionalText { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or sets the location names.
        /// </summary>
        /// <value>
        /// The location names.
        /// </value>
        public string? LocationNames { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int[] LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the location identifiers.
        /// </summary>
        /// <value>
        /// The location identifiers.
        /// </value>
        public string? LocationIdentifiers { get; set; }

        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        public string? UserName { get; set; }

        /// <summary>
        /// Gets or sets the salutation name.
        /// </summary>
        public string? SalutationName { get; set; }

        /// <summary>
        /// Gets or sets the is telemedicne.
        /// </summary>
        public bool? IsTelemedicine { get; set; }

        /// <summary>
        /// Gets or sets the isonline consultation.
        /// </summary>
        public bool? IsOnlineConsultation { get; set; }


        public int? ConsultationTypeId { get; set; }
        public int? ProviderAvailabilityId { get; set; }
        public string? StartDate { get; set; }
        public string? EndDate { get; set; }
        public string AvailableDay { get; set; }
        public string StartTime { get; set; }
        public string EndTime { get; set; }
        public int? FreeFollowUpDays { get; set; }
        public int? FreeFollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        public char? Type { get; set; }
        /// <summary>
        /// Gets or sets the employee.
        /// </summary>
        /// <value>
        /// The employee.
        /// </value>
        public char? Employee { get; set; }

        /// <summary>
        /// Gets or sets the type of the doctor.
        /// </summary>
        /// <value>
        /// The type of the doctor.
        /// </value>
        public char? DoctorType { get; set; }

        /// <summary>
        /// Gets or sets the pan card no.
        /// </summary>
        /// <value>
        /// The pan card no.
        /// </value>
        public string? PanCardNo { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier.
        /// </summary>
        /// <value>
        /// The unique identifier.
        /// </value>
        public Guid? Guid { get; set; }

        /// <summary>
        /// Gets or sets the location identifier names.
        /// </summary>
        public string? LocationIdentifierNames { get; set; }
    }
}
