﻿using System;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The shift slots.
    /// </summary>
    public class ShiftSlotModel
    {
        /// <summary>
        /// Gets or sets the start hour.
        /// </summary>
        public int? ShiftSlotId { get; set; }

        /// <summary>
        /// Gets or sets the start hour.
        /// </summary>
        public int StartHour { get; set; }

        /// <summary>
        /// Gets or sets the start minute.
        /// </summary>
        public int StartMinute { get; set; }


        /// <summary>
        /// Gets or sets the end hour.
        /// </summary>
        public int EndHour { get; set; }

        /// <summary>
        /// Gets or sets the end minute.
        /// </summary>
        public int EndMinute { get; set; }

        /// <summary>
        /// Gets or sets the start time.
        /// </summary>
        public TimeSpan StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end time.
        /// </summary>
        public TimeSpan EndTime { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the log from.
        /// </summary>
        public short? LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }
    }
}
