﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The inventory dashboard model.
    /// </summary>
    public class InventoryDashboardModel
    {
        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the available qty.
        /// </summary>
        public int AvailableQty { get; set; }

        /// <summary>
        /// Gets or sets the reorder level quantity.
        /// </summary>
        public int ReorderLevelQuantity { get; set; }

        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the days to expire.
        /// </summary>
        public int DaysToExpire { get; set; }
    }
}
