﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The inventory purchase bill return model.
    /// </summary>
    public class InventoryPurchaseBillReturnModel
    {
        /// <summary>
        /// Gets or sets the inventory purchase return header id.
        /// </summary>
        public int InventoryPurchaseReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the inventory purchase return detail id.
        /// </summary>
        public int InventoryPurchaseReturnDetailId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the return date.
        /// </summary>
        public DateTime ReturnDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double? TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double? NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall return amount.
        /// </summary>
        public double OverallReturnAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount rs.
        /// </summary>
        public double? OverallDiscountRs { get; set; }

        /// <summary>
        /// Gets or sets the overall taxes rs.
        /// </summary>
        public double OverallTaxesRs { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the inventory stock id.
        /// </summary>
        public int InventoryStockId { get; set; }

        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }
    }
}
