﻿namespace Hims.Shared.UserModels.Labs
{
    using System;

    /// <summary>
    /// The lab booking status model.
    /// </summary>
    public class LabBookingStatusModel
    {
        /// <summary>
        /// Gets or sets the lab booking time line identifier.
        /// </summary>
        /// <value>
        /// The lab booking time line identifier.
        /// </value>
        public int LabBookingTimeLineId { get; set; }

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the commented by.
        /// </summary>
        /// <value>
        /// The commented by.
        /// </value>
        public int CommentedBy { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the commented by.
        /// </summary>
        /// <value>
        /// The name of the commented by.
        /// </value>
        public string CommentedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the role.
        /// </summary>
        /// <value>
        /// The name of the role.
        /// </value>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
    }
}
