﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary> The chat fetch request model.</summary>
    public class PharmacyIndentIssueRevenueModel
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }
    
        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        public double overallTotal { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the approved by name.
        /// </summary>
        public string ApprovedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the request date.
        /// </summary>
        public DateTime? RequestDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the num requested items.
        /// </summary>
        public long NumRequestedItems { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public string Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the Patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the requested by.
        /// </summary>
        public int? RequestedBy { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int? Quantity { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }


        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double? OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }
    }
}
