﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary> The chat fetch request model.</summary>
    public class ReceiptReportsModel
    {
        /// <summary>
        /// Gets or sets the receipt created by.
        /// </summary>
        public string ReceiptCreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the receipt date.
        /// </summary>
        public DateTime ReceiptDate { get; set; }

        /// <summary>
        /// Gets or sets the receipt id.
        /// </summary>
        public string ReceiptId { get; set; }
        /// <summary>
        /// Gets or sets the receipt id.
        /// </summary>
        public int ReceiptTypeId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the father or husband.
        /// </summary>
        public string FatherOrHusband { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the paid amount.
        /// </summary>
        public double PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the refund amount.
        /// </summary>
        public double RefundAmount { get; set; }

        /// <summary>
        /// Gets or sets the balance amount.
        /// </summary>
        public double BalanceAmount { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the admission time.
        /// </summary>
        public string AdmissionTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public string AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the follow up for appointment.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment receipt.
        /// </summary>
        public bool IsAppointmentReceipt { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the payment type.
        /// </summary>

        public string PaymentType { get; set; }

        /// <summary>
        /// Gets or sets the payment transaction details.
        /// </summary>

        public string PaymentDetails { get; set; }

        /// <summary>
        /// Gets or sets the Area Type details.
        /// </summary>

        public string AreaType { get; set; }

        /// <summary>
        /// Gets or sets the Reference Id/NO.
        /// </summary>

        public string RefId { get; set; }
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string ANCCardGeneration { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        public bool IsHealthCard { get; set; }

        /// <summary>
        /// Gets or sets the pay type name.
        /// </summary>
        public string PayTypeName { get; set; }

    }

    public class BillDailyReport
    {
        /// <summary>
        /// Gets or sets the pay type amount.
        /// </summary>
        public decimal? PayTypeAmount { get; set; }

        /// <summary>
        /// Gets or sets the pay type name.
        /// </summary>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the pay type name.
        /// </summary>
        public string VisitorName { get; set; }

        /// <summary>
        /// Gets or sets the visit type count.
        /// </summary>
        public int? VisitTypeCount { get; set; }

        /// <summary>
        /// Gets or sets the pay type count.
        /// </summary>
        public int? PayTypeCount { get; set; }
    }
}
