﻿namespace Hims.Shared.UserModels.Reports

{
    using System;
    /// <summary>
    /// The receipt model
    /// </summary>
    public class BillDiscountModel

    {

        /// <summary>
        /// Gets or sets the Provider name.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the provider id
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double? Cost { get; set; }

        public string UMRNo { get; set; }
        public int? ReceiptAreaTypeId { get; set; }
        public string Type { get; set; }
        public double? Discount { get; set; }
        public double? Total { get; set; }
        public int? CreatedBy { get; set; }
        public DateTime? CreatedDate { get; set; }
        public string BilledBy { get; set; }
        public int? LocationId { get; set; }
        public string LocationName { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string FromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string ToDate { get; set; } = string.Empty;
       
        /// <summary>
        /// Gets or sets the location
        /// </summary>
        public int? ModuleId { get; set; }
        public string Authority { get; set; }
        public string Reason { get; set; }
    }
}
