﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Vendors
{
    public class VendorViewModel
    {
        /// <summary>
        /// Gets or sets the tender request supplier header identifier.
        /// </summary>
        /// <value>
        /// The tender request supplier header identifier.
        /// </value>

        public long TenderRequestSupplierHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }

        /// <summary>
        /// Gets or sets the tender raised by.
        /// </summary>
        /// <value>
        /// The tender raised by.
        /// </value>
        public int TenderRaisedBy { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the tender raised date.
        /// </summary>
        /// <value>
        /// The tender raised date.
        /// </value>
        public DateTime TenderRaisedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is complete accepted.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is complete accepted; otherwise, <c>false</c>.
        /// </value>
        public bool IsCompleteAccepted { get; set; }

        /// <summary>
        /// Gets or sets the accepted date.
        /// </summary>
        /// <value>
        /// The accepted date.
        /// </value>
        public DateTime? AcceptedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is complete rejected.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is complete rejected; otherwise, <c>false</c>.
        /// </value>
        public bool IsCompleteRejected { get; set; }

        /// <summary>
        /// Gets or sets the complete rejected date.
        /// </summary>
        /// <value>
        /// The complete rejected date.
        /// </value>
        public DateTime? CompleteRejectedDate { get; set; }

        /// <summary>
        /// Gets or sets the complete rejection comment.
        /// </summary>
        /// <value>
        /// The complete rejection comment.
        /// </value>
        public string CompleteRejectionComment { get; set; }

        /// <summary>
        /// Gets or sets the name of the supplier.
        /// </summary>
        /// <value>
        /// The name of the supplier.
        /// </value>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the address.
        /// </summary>
        /// <value>
        /// The address.
        /// </value>
        public string Address { get; set; }

        /// <summary>
        /// Gets or sets the pin code.
        /// </summary>
        /// <value>
        /// The pin code.
        /// </value>
        public string PinCode { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        /// <value>
        /// The email.
        /// </value>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the name of the contact person.
        /// </summary>
        /// <value>
        /// The name of the contact person.
        /// </value>
        public string ContactPersonName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        /// <value>
        /// The mobile.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the name of the tender raised by.
        /// </summary>
        /// <value>
        /// The name of the tender raised by.
        /// </value>
        public string TenderRaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is accepted.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is accepted; otherwise, <c>false</c>.
        /// </value>
        public bool IsAccepted { get; set; }
    }


    public class VendorViewDetailModel
    {
        /// <summary>
        /// Gets or sets the tender request supplier detail identifier.
        /// </summary>
        /// <value>
        /// The tender request supplier detail identifier.
        /// </value>
        public long? TenderRequestSupplierDetailId { get; set; }

        /// <summary>
        /// Gets or sets the tender request supplier header identifier.
        /// </summary>
        /// <value>
        /// The tender request supplier header identifier.
        /// </value>
        public long? TenderRequestSupplierHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the vendor MRP.
        /// </summary>
        /// <value>
        /// The vendor MRP.
        /// </value>
        public double? VendorMrp { get; set; }

        /// <summary>
        /// Gets or sets the vendor purchase rate.
        /// </summary>
        /// <value>
        /// The vendor purchase rate.
        /// </value>
        public double? VendorPurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [vendor rejected].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [vendor rejected]; otherwise, <c>false</c>.
        /// </value>
        public bool VendorRejected { get; set; }

        /// <summary>
        /// Gets or sets the vendor rejected date.
        /// </summary>
        /// <value>
        /// The vendor rejected date.
        /// </value>
        public DateTime? VendorRejectedDate { get; set; }

        /// <summary>
        /// Gets or sets the rejection comment.
        /// </summary>
        /// <value>
        /// The rejection comment.
        /// </value>
        public string RejectionComment { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double? PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        /// <value>
        /// The purchase unit qty.
        /// </value>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        /// <value>
        /// The sale unit qty.
        /// </value>
        public int SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sale unit.
        /// </summary>
        /// <value>
        /// The name of the sale unit.
        /// </value>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the raised by.
        /// </summary>
        /// <value>
        /// The name of the raised by.
        /// </value>
        public string RaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the delivery location.
        /// </summary>
        /// <value>
        /// The delivery location.
        /// </value>
        public string DeliveryLocation { get; set; }

        /// <summary>
        /// Gets or sets the name of the supplier.
        /// </summary>
        /// <value>
        /// The name of the supplier.
        /// </value>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int? SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the tender raised date.
        /// </summary>
        /// <value>
        /// The tender raised date.
        /// </value>
        public DateTime? TenderRaisedDate { get; set; }

        /// <summary>
        /// Gets or sets the accepted date.
        /// </summary>
        /// <value>
        /// The accepted date.
        /// </value>
        public DateTime? AcceptedDate { get; set; }

        /// <summary>
        /// Gets or sets the reorder quantity.
        /// </summary>
        /// <value>
        /// The reorder quantity.
        /// </value>
        public int ReorderQuantity { get; set; }

        /// <summary>
        /// Gets or sets the type of the fetch.
        /// </summary>
        /// <value>
        /// The type of the fetch.
        /// </value>
        public string FetchType { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }        
    }
}
