﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment log.
    /// </summary>
    public class AppointmentLog
    {
        /// <summary>
        /// Gets or sets the appointment log id.
        /// </summary>
        [Key, Identity]
        public int AppointmentLogId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        //public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public char? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public char? ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment notes.
        /// </summary>
        public string? AppointmentNotes { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }
        
        /// <summary>
        /// Gets or sets the app charges.
        /// </summary>
        public decimal AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the wallet amount.
        /// </summary>
        public decimal? WalletAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public double? Percentage { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        ///  Gets or sets payment type.
        /// </summary>
        public string? PaymentType { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment type id.
        /// </summary>
        public int? AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        public int TokenNumber { get; set; }

        /// <summary>
        /// Gets or sets the SpecializationId.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the receipt type id.
        /// </summary>
        public int ReceiptTypeId { get; set; }

        /// <summary>
        /// Gets or sets the receipt area type id.
        /// </summary>
        public int ReceiptAreaTypeId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the registration charges. 
        /// this value is used to add in Patient table (while inserting new patient either identify or unidentify patient.)
        /// </summary>
        public decimal? PatientRegistrationCharges { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int? DoctorSpecializationChargeModuleDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the session id.
        /// </summary>
        public int? SessionId { get; set; }
    }
}
