﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities
{
    public class Counselling
    {
        [Key, Identity]
        public int CounsellingId { get; set; }

        public int CounsellingTypeId { get; set; }

        [IgnoreUpdate]
        public string CounsellingNo { get; set; }

        public int LocationId { get; set; }

        public int PatientId { get; set; }

        public int PackageModuleId { get; set; }

        public int ChargeCategoryId { get; set; }

        public short TotalQuantity { get; set; }

        public decimal SubTotal { get; set; }

        public string DiscountType { get; set; }

        public decimal? DiscountPercentage { get; set; }

        public decimal? DiscountAmount { get; set; }

        public decimal PackageDiscount { get; set; }

        public decimal Discount { get; set; }

        public decimal Total { get; set; }

        public string PatientSignature { get; set; }

        public string CounsellorSignature { get; set; }

        public bool IsDraft { get; set; }

        public bool Active { get; set; }

        public bool IsInUse { get; set; }

        public int? PayTypeId { get; set; }

        public int? InsuranceCompanyId { get; set; }

        public int? TPAId { get; set; }

        public string PatientOrganization { get; set; }

        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        public int? ModifiedBy { get; set; }

        public DateTime? ModifiedDate { get; set; }
    }
}
