﻿namespace Hims.Domain.Entities.Inventory
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The inventory product rack.
    /// </summary>
    public class InventoryProductRack
    {
        /// <summary>
        /// Gets or sets the inventory product rack identifier.
        /// </summary>
        /// <value>
        /// The inventory product rack identifier.
        /// </value>
        [Key,Identity]
        public int InventoryProductRackId { get; set; }

        /// <summary>
        /// Gets or sets the name of the rack.
        /// </summary>
        /// <value>
        /// The name of the rack.
        /// </value>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the inventory ware house identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house identifier.
        /// </value>
        public int? InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int? InventoryDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
    }
}
