﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.PediatricGraph
{
    /// <summary>
    /// The pediatric age wise data.
    /// </summary>
    public class PediatricAgeWiseData
    {
        /// <summary>
        /// Gets or sets the pediatric age wise data identifier.
        /// </summary>
        /// <value>
        /// The pediatric age wise data identifier.
        /// </value>
        [Key,Identity]
        public int PediatricAgeWiseDataId { get; set; }

        /// <summary>
        /// Gets or sets the pediatric chart authority identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart authority identifier.
        /// </value>
        public int PediatricChartAuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the pediatric chart type identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart type identifier.
        /// </value>
        public int PediatricChartTypeId { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age in month.
        /// </summary>
        /// <value>
        /// The age in month.
        /// </value>
        public int AgeInMonth { get; set; }

        /// <summary>
        /// Gets or sets the sd.
        /// </summary>
        /// <value>
        /// The sd.
        /// </value>
        public double? SD { get; set; }

        /// <summary>
        /// Gets or sets the p1.
        /// </summary>
        /// <value>
        /// The p1.
        /// </value>
        public double P1 { get; set; }

        /// <summary>
        /// Gets or sets the p3.
        /// </summary>
        /// <value>
        /// The p3.
        /// </value>
        public double P3 { get; set; }

        /// <summary>
        /// Gets or sets the p5.
        /// </summary>
        /// <value>
        /// The p5.
        /// </value>
        public double P5 { get; set; }

        /// <summary>
        /// Gets or sets the P15.
        /// </summary>
        /// <value>
        /// The P15.
        /// </value>
        public double P15 { get; set; }

        /// <summary>
        /// Gets or sets the P25.
        /// </summary>
        /// <value>
        /// The P25.
        /// </value>
        public double P25 { get; set; }

        /// <summary>
        /// Gets or sets the P50.
        /// </summary>
        /// <value>
        /// The P50.
        /// </value>
        public double P50 { get; set; }

        /// <summary>
        /// Gets or sets the P75.
        /// </summary>
        /// <value>
        /// The P75.
        /// </value>
        public double P75 { get; set; }

        /// <summary>
        /// Gets or sets the P85.
        /// </summary>
        /// <value>
        /// The P85.
        /// </value>
        public double P85 { get; set; }

        /// <summary>
        /// Gets or sets the P95.
        /// </summary>
        /// <value>
        /// The P95.
        /// </value>
        public double P95 { get; set; }

        /// <summary>
        /// Gets or sets the P97.
        /// </summary>
        /// <value>
        /// The P97.
        /// </value>
        public double P97 { get; set; }

        /// <summary>
        /// Gets or sets the P99.
        /// </summary>
        /// <value>
        /// The P99.
        /// </value>
        public double P99 { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="PediatricAgeWiseData"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }
    }
}
