﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy indent header.
    /// </summary>
    public class PharmacyIndentHeader
    {
        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        [Key, Identity]
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the indent date.
        /// </summary>
        public DateTime IndentDate { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }
    }
}
