﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class ProviderBreak
    {
        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        [Key, Identity]
        public int? ProviderBreakId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation duration.
        /// </summary>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string BreakDay { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartTime { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndTime { get; set; }

        /// <summary>
        /// Gets or sets the available date.
        /// </summary>
        public string? BreakDate { get; set; }

        /// <summary>
        /// Gets or sets the Break Type.
        /// </summary>
        public string? BreakType { get; set; }

        /// <summary>
        /// Gets or sets the Break Block.
        /// </summary>
        public string? BreakBlock { get; set; }

        /// <summary>
        /// Getes or sets the doctorweekId.
        /// </summary>
        public int? DoctorWeekId { get; set; }

    }
}
