﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The scan sub classification Identifier
    /// </summary>
#pragma warning disable S101 // Types should be named in PascalCase
    public class ScanSubClassification
#pragma warning restore S101 // Types should be named in PascalCase
    {
        /// <summary>
        /// Gets or sets the scan  sub classification id.
        /// </summary>
        /// <value>
        /// The scan  sub classification id identifier.
        /// </value>
        [Key, Identity]
        public int ScanSubClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the scan classification id.
        /// </summary>
        /// <value>
        /// The scan  classification id identifier.
        /// </value>
        public int ScanClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the scan classification.
        /// </summary>
        /// <value>
        /// The name of the scan classification.
        /// </value>
        public string ScanSubClassificationName { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ScanClassification"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

    }
}
