﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Hims.Domain.Entities.Vendors
{
    /// <summary>
    /// The product for quotation header.
    /// </summary>
    [Table("ProductForQuotationHeader", Schema = "vendors")]
    public class ProductForQuotationHeader
    {
        /// <summary>
        /// Gets or sets the product for quotation header identifier.
        /// </summary>
        /// <value>
        /// The product for quotation header identifier.
        /// </value>
        [Key,Identity]
        public long ProductForQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the quotation number.
        /// </summary>
        /// <value>
        /// The quotation number.
        /// </value>
        public string QuotationNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }
    }
}
