﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class WhatsAppTickets
    {
        /// <summary>
        /// Gets or sets the TicketId.
        /// </summary>
         [Key, Identity]
        public int TicketId { get; set; }

        /// <summary>
        /// Gets or sets the TicketNo.
        /// </summary>
        public string TicketNo { get; set; }

        /// <summary>
        /// Gets or sets the Mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the Name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the Regarding.
        /// </summary>
        public string Regarding { get; set; }

        /// <summary>
        /// Gets or sets the Solved.
        /// </summary>
        public bool Solved { get; set; }
        /// <summary>
        /// Gets or sets The CreatedDate
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets The ModifiedDate
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
